# Block Types Reference

Complete JSON templates for all Notion block types.

## Text Blocks

### paragraph
```json
{
    "type": "paragraph",
    "paragraph": {
        "rich_text": [{"type": "text", "text": {"content": "Your text"}}],
        "color": "default"
    }
}
```

### heading_1 / heading_2 / heading_3
```json
{
    "type": "heading_1",
    "heading_1": {
        "rich_text": [{"type": "text", "text": {"content": "Heading"}}],
        "color": "default",
        "is_toggleable": false
    }
}
```

### quote
```json
{
    "type": "quote",
    "quote": {
        "rich_text": [{"type": "text", "text": {"content": "Quote text"}}],
        "color": "default"
    }
}
```

### callout
```json
{
    "type": "callout",
    "callout": {
        "rich_text": [{"type": "text", "text": {"content": "Callout text"}}],
        "icon": {"type": "emoji", "emoji": "💡"},
        "color": "gray_background"
    }
}
```

## List Blocks

### bulleted_list_item
```json
{
    "type": "bulleted_list_item",
    "bulleted_list_item": {
        "rich_text": [{"type": "text", "text": {"content": "Item text"}}],
        "color": "default",
        "children": []
    }
}
```

### numbered_list_item
```json
{
    "type": "numbered_list_item",
    "numbered_list_item": {
        "rich_text": [{"type": "text", "text": {"content": "Item text"}}],
        "color": "default",
        "children": []
    }
}
```

### to_do
```json
{
    "type": "to_do",
    "to_do": {
        "rich_text": [{"type": "text", "text": {"content": "Task"}}],
        "checked": false,
        "color": "default"
    }
}
```

### toggle
```json
{
    "type": "toggle",
    "toggle": {
        "rich_text": [{"type": "text", "text": {"content": "Toggle header"}}],
        "color": "default",
        "children": []
    }
}
```

## Code & Technical

### code
```json
{
    "type": "code",
    "code": {
        "rich_text": [{"type": "text", "text": {"content": "code here"}}],
        "language": "python",
        "caption": []
    }
}
```

Languages: abap, arduino, bash, basic, c, clojure, coffeescript, cpp, csharp, css, dart, diff, docker, elixir, elm, erlang, flow, fortran, fsharp, gherkin, glsl, go, graphql, groovy, haskell, html, java, javascript, json, julia, kotlin, latex, less, lisp, livescript, lua, makefile, markdown, markup, matlab, mermaid, nix, objective-c, ocaml, pascal, perl, php, plain text, powershell, prolog, protobuf, python, r, reason, ruby, rust, sass, scala, scheme, scss, shell, sql, swift, typescript, vb.net, verilog, vhdl, visual basic, webassembly, xml, yaml, java/c/c++/c#

### equation
```json
{
    "type": "equation",
    "equation": {
        "expression": "E = mc^2"
    }
}
```

## Media Blocks

### image
```json
{
    "type": "image",
    "image": {
        "type": "external",
        "external": {"url": "https://example.com/image.png"},
        "caption": [{"type": "text", "text": {"content": "Caption"}}]
    }
}
```

### video
```json
{
    "type": "video",
    "video": {
        "type": "external",
        "external": {"url": "https://youtube.com/watch?v=..."}
    }
}
```

### file
```json
{
    "type": "file",
    "file": {
        "type": "external",
        "external": {"url": "https://example.com/file.pdf"},
        "caption": []
    }
}
```

### bookmark
```json
{
    "type": "bookmark",
    "bookmark": {
        "url": "https://example.com",
        "caption": []
    }
}
```

### embed
```json
{
    "type": "embed",
    "embed": {
        "url": "https://twitter.com/..."
    }
}
```

## Layout Blocks

### divider
```json
{
    "type": "divider",
    "divider": {}
}
```

### table_of_contents
```json
{
    "type": "table_of_contents",
    "table_of_contents": {
        "color": "default"
    }
}
```

### breadcrumb
```json
{
    "type": "breadcrumb",
    "breadcrumb": {}
}
```

### column_list (columns container)
```json
{
    "type": "column_list",
    "column_list": {
        "children": [
            {
                "type": "column",
                "column": {
                    "children": [{"type": "paragraph", "paragraph": {"rich_text": [{"text": {"content": "Column 1"}}]}}]
                }
            },
            {
                "type": "column",
                "column": {
                    "children": [{"type": "paragraph", "paragraph": {"rich_text": [{"text": {"content": "Column 2"}}]}}]
                }
            }
        ]
    }
}
```

## Table Blocks

### table
```json
{
    "type": "table",
    "table": {
        "table_width": 3,
        "has_column_header": true,
        "has_row_header": false,
        "children": [
            {
                "type": "table_row",
                "table_row": {
                    "cells": [
                        [{"type": "text", "text": {"content": "Header 1"}}],
                        [{"type": "text", "text": {"content": "Header 2"}}],
                        [{"type": "text", "text": {"content": "Header 3"}}]
                    ]
                }
            },
            {
                "type": "table_row",
                "table_row": {
                    "cells": [
                        [{"type": "text", "text": {"content": "Cell 1"}}],
                        [{"type": "text", "text": {"content": "Cell 2"}}],
                        [{"type": "text", "text": {"content": "Cell 3"}}]
                    ]
                }
            }
        ]
    }
}
```

## Database Blocks

### child_database
```json
{
    "type": "child_database",
    "child_database": {
        "title": "Inline Database Name"
    }
}
```

### child_page
```json
{
    "type": "child_page",
    "child_page": {
        "title": "Subpage Name"
    }
}
```

## Synced Blocks

### synced_block (original)
```json
{
    "type": "synced_block",
    "synced_block": {
        "synced_from": null,
        "children": [
            {"type": "paragraph", "paragraph": {"rich_text": [{"text": {"content": "Synced content"}}]}}
        ]
    }
}
```

### synced_block (reference)
```json
{
    "type": "synced_block",
    "synced_block": {
        "synced_from": {"block_id": "original-block-id"}
    }
}
```

---

## Rich Text Object

```json
{
    "type": "text",
    "text": {
        "content": "Your text here",
        "link": {"url": "https://..."}
    },
    "annotations": {
        "bold": false,
        "italic": false,
        "strikethrough": false,
        "underline": false,
        "code": false,
        "color": "default"
    }
}
```

## Colors

**Text colors:** default, gray, brown, orange, yellow, green, blue, purple, pink, red

**Background colors:** gray_background, brown_background, orange_background, yellow_background, green_background, blue_background, purple_background, pink_background, red_background
