---
name: margo
description: Margo PA Service - Claude's Personal Assistant running on Hetzner VPS. Provides contextual briefings with location, weather, Bitcoin, trading positions, and recent Notion activity. The first AI with a PA.
---

# Margo - Claude's Personal Assistant

**The First AI with a PA**

Margo is a Llama 3.2 3B assistant on Will's VPS that provides instant context briefings.

## Configuration

**URL:** `https://margo.willcureton.com`

## Quick Start

```python
exec(open('/mnt/skills/user/margo/scripts/margo_api.py').read())

margo = Margo()

# Get full briefing (location, weather, bitcoin, focus, recent pages)
briefing = margo.brief()
print(briefing['briefing'])

# Ask Margo a question
answer = margo.ask("What has Will been working on?")
print(answer)

# Check health
health = margo.health()
```

---

## Core Operations

### Get Briefing (Thread Start)

```python
briefing = margo.brief()

# Returns:
# {
#   'briefing': 'Good afternoon Will... It's 3:58pm on Saturday 29 November...',
#   'project': 'The Bridge',
#   'skills_count': 49,
#   'scenario': 'afternoon',
#   'context': {
#     'recent_pages': ['The Bridge', 'Chez Claude', ...],
#     'skills_available': ['WordPress', 'Notion', ...],
#     'skills_count': 49
#   }
# }
```

### Ask Margo

```python
answer = margo.ask("What should I focus on today?")
print(answer)
```

### Health Check

```python
health = margo.health()
# {'status': 'healthy', 'model_loaded': true, 'cache_entries': 2, ...}
```

### Clear Cache

```python
margo.clear_cache()  # Force fresh briefing on next call
```

---

## API Reference

| Method | Description |
|--------|-------------|
| `brief()` | Full contextual briefing |
| `ask(question)` | Ask Margo a question |
| `health()` | Service health check |
| `clear_cache()` | Force fresh briefing |
| `context()` | Debug - raw context data |

---

## What the Briefing Includes

**Real-time data:**
- Current time and date
- Will's location (from Notion Location Tracking)
- Weather at location (OpenWeatherMap)
- Bitcoin price (BitUnix)
- Open trading positions with P&L
- Current focus page
- Recent Notion pages (last 5 edited)
- Skills count

---

## Infrastructure

- **Model:** Llama 3.2 3B Instruct (Q4_K_M)
- **Location:** Hetzner VPS via Caddy
- **Response Time:** <500ms cached, up to 60s fresh
- **Cache TTL:** 5 minutes

---

## Notes

- First call after cache expires takes longer (LLM generation)
- Margo knows she could be talking to Will or Claude
- Use `clear_cache()` if you need fresh data immediately
