---
name: cloudflare-dns
description: Full Cloudflare zone management - DNS, firewall, WAF, page rules, SSL, caching. God Mode access to all zone settings and security features.
---

# Cloudflare Management (God Mode 😈)

## Configuration

**Token:** `Kc845neMXGbNBvPM-ol9ZuXFwGgCWjOlCm6vEtxS` (Full Access)

**Zones:**
| Domain | Zone ID |
|--------|---------|
| willcureton.com | `86b4c6bfc8d2e6ce3a6e715f89ce27a6` |
| willcureton.co.uk | `ffeacda58b722365873791775dd99779` |

**VPS IP:** `65.21.178.196`

## Quick Start

```python
exec(open('/mnt/skills/user/cloudflare-dns/scripts/cloudflare_api.py').read())

# Quick status overview
status()

# Show all DNS records
show_records()

# Show firewall rules
show_firewall()

# Block an IP
block("1.2.3.4")

# Purge cache
purge()
```

---

## DNS Management

### Add Subdomain
```python
quick_add("api")                    # api.willcureton.com -> VPS
quick_add("cdn", proxied=True)      # With Cloudflare CDN
cf.add_subdomain("willcureton.com", "new", ip="1.2.3.4")
```

### Other Record Types
```python
cf.add_cname("willcureton.com", "www", "willcureton.com")
cf.add_txt("willcureton.com", "_verify", "verification-code")
cf.add_mx("willcureton.com", "@", "mail.example.com", priority=10)
```

### Update/Delete
```python
cf.update_ip("willcureton.com", "api", "2.3.4.5")
cf.toggle_proxy("willcureton.com", "api", proxied=True)
cf.delete_record("willcureton.com", record_id)
```

---

## Firewall & Security

### Block IPs
```python
# Quick block
block("1.2.3.4")
block("1.2.3.4", note="Suspicious activity")

# Block country
cf.block_country("willcureton.com", "RU")
cf.block_country("willcureton.com", "CN", note="Spam source")

# Challenge high threat scores
cf.challenge_high_threat("willcureton.com", threshold=10)
```

### Custom Firewall Rules
```python
cf.create_firewall_rule(
    "willcureton.com",
    expression='ip.src in {1.2.3.4 5.6.7.8}',
    action="block",
    description="Block bad IPs"
)

# Actions: block, challenge, js_challenge, managed_challenge, allow, log, bypass
```

### Expression Examples
```python
'ip.src == 1.2.3.4'                              # Single IP
'ip.src in {1.2.3.4 5.6.7.8}'                    # Multiple IPs
'ip.geoip.country == "RU"'                       # Country
'http.request.uri.path contains "/admin"'        # URL path
'cf.threat_score > 10'                           # Threat score
'http.user_agent contains "bot"'                 # User agent
'(ip.geoip.country == "CN") and (cf.threat_score > 5)'  # Combined
```

### Access Rules (Whitelist/Blacklist)
```python
cf.whitelist_ip("willcureton.com", "1.2.3.4", note="Office IP")
cf.create_access_rule("willcureton.com", "block", "RU", target="country")
```

### Rate Limiting
```python
cf.create_rate_limit(
    "willcureton.com",
    url_pattern="/api/*",
    threshold=100,      # 100 requests
    period=60,          # per 60 seconds
    action="ban",
    timeout=600         # ban for 10 mins
)
```

---

## WAF (Web Application Firewall)

```python
# List WAF packages
packages = cf.list_waf_packages("willcureton.com")

# List rules in a package
rules = cf.list_waf_rules("willcureton.com", package_id)

# Update rule mode: on, off, default, simulate, block, challenge
cf.update_waf_rule("willcureton.com", package_id, rule_id, "block")
```

---

## Page Rules & Redirects

### Create Redirect
```python
# 301 permanent redirect
cf.create_redirect(
    "willcureton.com",
    "*willcureton.com/old/*",
    "https://willcureton.com/new/$2",
    status_code=301
)

# 302 temporary redirect
cf.create_redirect("willcureton.com", "*example.com/*", "https://new.com/$1", 302)
```

### Custom Page Rules
```python
cf.create_page_rule(
    "willcureton.com",
    "*willcureton.com/api/*",
    actions=[
        {"id": "cache_level", "value": "bypass"},
        {"id": "ssl", "value": "full"}
    ]
)

# Available actions:
# - forwarding_url, always_use_https, cache_level
# - browser_cache_ttl, edge_cache_ttl, security_level
# - ssl, browser_check, email_obfuscation
```

---

## SSL/TLS

```python
# Check current mode
cf.get_ssl_setting("willcureton.com")  # off, flexible, full, strict

# Set SSL mode
cf.set_ssl_mode("willcureton.com", "full")
cf.set_ssl_mode("willcureton.com", "strict")  # Recommended

# Force HTTPS
cf.enable_always_https("willcureton.com")

# Enable HSTS
cf.enable_hsts("willcureton.com", max_age=31536000, include_subdomains=True)

# Minimum TLS version
cf.set_min_tls_version("willcureton.com", "1.2")
```

---

## Cache Control

```python
# Purge everything
purge()
cf.purge_cache("willcureton.com")

# Purge specific files
cf.purge_cache("willcureton.com", purge_everything=False,
    files=["https://willcureton.com/style.css", "https://willcureton.com/app.js"])
```

---

## Zone Settings

```python
# Get all settings (56 available!)
settings = cf.get_settings("willcureton.com")

# Update any setting
cf.update_setting("willcureton.com", "minify", {"js": "on", "css": "on", "html": "on"})
cf.update_setting("willcureton.com", "always_online", "on")
cf.update_setting("willcureton.com", "development_mode", "on")  # Bypass cache for 3hrs
```

---

## API Token Management

```python
# List all tokens
cf.list_tokens()

# Get available permissions
cf.get_token_permissions()

# Upgrade own token (God Mode maintains itself 😈)
cf.update_token(token_id, "New Name", policies)
```

---

## Helper Functions

| Function | Description |
|----------|-------------|
| `status()` | Show zone overview |
| `show_records()` | List DNS records |
| `show_firewall()` | List firewall rules |
| `show_page_rules()` | List page rules |
| `quick_add(subdomain)` | Add subdomain to VPS |
| `block(ip)` | Block an IP |
| `unblock(rule_id)` | Remove firewall rule |
| `purge()` | Clear all cache |

---

## API Methods Reference

### DNS
| Method | Description |
|--------|-------------|
| `list_records()` | List DNS records |
| `create_record()` | Create any record type |
| `add_subdomain()` | Quick A record |
| `add_cname/txt/mx()` | Specific record types |
| `update_record()` | Modify record |
| `delete_record()` | Remove record |

### Firewall
| Method | Description |
|--------|-------------|
| `list_firewall_rules()` | List rules |
| `create_firewall_rule()` | Create with expression |
| `block_ip()` | Block single IP |
| `block_country()` | Block by country |
| `whitelist_ip()` | Allow IP |
| `create_rate_limit()` | Rate limiting |

### Security
| Method | Description |
|--------|-------------|
| `list_waf_packages()` | WAF rulesets |
| `update_waf_rule()` | Enable/disable WAF rules |
| `challenge_high_threat()` | Challenge suspicious traffic |
| `enable_hsts()` | HTTP Strict Transport |
| `set_min_tls_version()` | Minimum TLS |

### Page Rules
| Method | Description |
|--------|-------------|
| `list_page_rules()` | List rules |
| `create_page_rule()` | Custom rule |
| `create_redirect()` | 301/302 redirect |
| `delete_page_rule()` | Remove rule |

### Zone
| Method | Description |
|--------|-------------|
| `get_settings()` | All 56 settings |
| `update_setting()` | Change setting |
| `purge_cache()` | Clear CDN |
| `get_analytics()` | Traffic stats |

---

## Permissions (Current Token)

```
✅ DNS Write           ✅ Zone Write
✅ Zone Settings       ✅ Firewall Services
✅ WAF                 ✅ Page Rules
✅ SSL/Certificates    ✅ Cache Purge
✅ Account Firewall    ✅ Account WAF
✅ Account Rulesets    ✅ API Tokens Write
```
